﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.Utilities;

namespace AZVIC.Ei8htPOS.DAL
{


    public class OrdersDB
    {
        public static Orders GetItem(Guid ordersID, Guid userAccountID, string keyword, DateTime fromDate, DateTime toDate)
        {
            Orders myOrders = null;

            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@OrdersID", ((ordersID != Guid.Empty && ordersID != null) ? ordersID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@UserAccountID", ((userAccountID != Guid.Empty && userAccountID != null) ? userAccountID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@FromDate", (fromDate == DateTime.MinValue ? (object)DBNull.Value : fromDate)));
            parameters.Add(new SqlParameter("@ToDate", (toDate == DateTime.MinValue ? (object)DBNull.Value : toDate)));
            parameters.Add(new SqlParameter("@Keyword", (string.IsNullOrEmpty(keyword) ? (object)DBNull.Value : keyword)));

            myOrders = SQLHelper.RetrieveObject<Orders>("spGetOrders", parameters);
            myOrders.OrdersDetailsList = OrdersDetailsDB.GetList(Guid.Empty, myOrders.UniqueID, string.Empty);
            myOrders.OrdersPaymentList = OrdersPaymentDB.GetList(Guid.Empty, myOrders.UniqueID, DateTime.MinValue, DateTime.MinValue);
            return myOrders;
        }

        public static List<Orders> GetList(Guid ordersID, Guid userAccountID, string keyword, DateTime fromDate, DateTime toDate)
        {
            List<Orders> myList = null;

            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@OrdersID", ((ordersID != Guid.Empty && ordersID != null) ? ordersID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@UserAccountID", ((userAccountID != Guid.Empty && userAccountID != null) ? userAccountID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@FromDate", (fromDate == DateTime.MinValue ? (object)DBNull.Value : fromDate)));
            parameters.Add(new SqlParameter("@ToDate", (toDate == DateTime.MinValue ? (object)DBNull.Value : toDate)));
            parameters.Add(new SqlParameter("@Keyword", (string.IsNullOrEmpty(keyword) ? (object)DBNull.Value : keyword)));

            myList = SQLHelper.RetrieveList<Orders>("spGetOrders", parameters);

            foreach (Orders currentTransaction in myList)
            {
                currentTransaction.OrdersDetailsList = OrdersDetailsDB.GetList(Guid.Empty, currentTransaction.UniqueID, string.Empty);
            }

            return myList;
        }

        public static List<Orders> GetOfflineList(Guid ordersID, Guid userAccountID, string keyword, DateTime fromDate, DateTime toDate)
        {
            List<Orders> myList = null;

            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@OrdersID", ((ordersID != Guid.Empty && ordersID != null) ? ordersID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@UserAccountID", ((userAccountID != Guid.Empty && userAccountID != null) ? userAccountID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@FromDate", (fromDate == DateTime.MinValue ? (object)DBNull.Value : fromDate)));
            parameters.Add(new SqlParameter("@ToDate", (toDate == DateTime.MinValue ? (object)DBNull.Value : toDate)));
            parameters.Add(new SqlParameter("@Keyword", (string.IsNullOrEmpty(keyword) ? (object)DBNull.Value : keyword)));

            myList = SQLHelper.RetrieveOfflineList<Orders>("spGetOrders", parameters);

            foreach (Orders currentTransaction in myList)
            {
                currentTransaction.OrdersDetailsList = OrdersDetailsDB.GetOfflineList(Guid.Empty, currentTransaction.UniqueID, string.Empty);
            }


            return myList;
        }

        public static DataTable GetDataTable(Guid ordersID, Guid userAccountID, string keyword, DateTime fromDate, DateTime toDate)
        {

            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@OrdersID", ((ordersID != Guid.Empty && ordersID != null) ? ordersID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@UserAccountID", ((userAccountID != Guid.Empty && userAccountID != null) ? userAccountID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@FromDate", (fromDate == DateTime.MinValue ? (object)DBNull.Value : fromDate)));
            parameters.Add(new SqlParameter("@ToDate", (toDate == DateTime.MinValue ? (object)DBNull.Value : toDate)));
            parameters.Add(new SqlParameter("@Keyword", (string.IsNullOrEmpty(keyword) ? (object)DBNull.Value : keyword)));

            return SQLHelper.ExecuteDataTable("spGetOrders", parameters);

        }

        public static DataSet GetDataSet(Guid ordersID, Guid userAccountID, string keyword, DateTime fromDate, DateTime toDate)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@OrdersID", ((ordersID != Guid.Empty && ordersID != null) ? ordersID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@UserAccountID", ((userAccountID != Guid.Empty && userAccountID != null) ? userAccountID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@FromDate", (fromDate == DateTime.MinValue ? (object)DBNull.Value : fromDate)));
            parameters.Add(new SqlParameter("@ToDate", (toDate == DateTime.MinValue ? (object)DBNull.Value : toDate)));
            parameters.Add(new SqlParameter("@Keyword", (string.IsNullOrEmpty(keyword) ? (object)DBNull.Value : keyword)));

            return SQLHelper.ExecuteDataSet("spGetOrders", parameters);

        }

        public static void Save(Orders myOrders)
        {
            myOrders.Mode = ((myOrders.UniqueID != Guid.Empty && myOrders.UniqueID != null) ? GlobalConfigurations.Mode.Update : GlobalConfigurations.Mode.Insert);
            myOrders.UniqueID = ((myOrders.UniqueID != Guid.Empty && myOrders.UniqueID != null) ? myOrders.UniqueID : Guid.NewGuid());
            if (myOrders.Mode == GlobalConfigurations.Mode.Insert)
            {
                myOrders.IsActive = true;
            }

            List<SqlParameter> parameters = new List<SqlParameter>();

            parameters.Add(new SqlParameter("@OrdersID", myOrders.UniqueID));
            parameters.Add(new SqlParameter("@OrderFrom", (string.IsNullOrEmpty(myOrders.OrderFrom) ? (object)DBNull.Value : myOrders.OrderFrom)));
            parameters.Add(new SqlParameter("@UsersAccountID", ((myOrders.UsersAccountID != Guid.Empty && myOrders.UsersAccountID != null) ? myOrders.UsersAccountID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@FirstName", (string.IsNullOrEmpty(myOrders.FirstName) ? (object)DBNull.Value : myOrders.FirstName)));
            parameters.Add(new SqlParameter("@LastName", (string.IsNullOrEmpty(myOrders.LastName) ? (object)DBNull.Value : myOrders.LastName)));
            parameters.Add(new SqlParameter("@Email", (string.IsNullOrEmpty(myOrders.Email) ? (object)DBNull.Value : myOrders.Email)));
            parameters.Add(new SqlParameter("@Company", (string.IsNullOrEmpty(myOrders.Company) ? (object)DBNull.Value : myOrders.Company)));
            parameters.Add(new SqlParameter("@BillingAddress1", (string.IsNullOrEmpty(myOrders.BillingAddress1) ? (object)DBNull.Value : myOrders.BillingAddress1)));
            parameters.Add(new SqlParameter("@BillingAddress2", (string.IsNullOrEmpty(myOrders.BillingAddress2) ? (object)DBNull.Value : myOrders.BillingAddress2)));
            parameters.Add(new SqlParameter("@BillingCity", (string.IsNullOrEmpty(myOrders.BillingCity) ? (object)DBNull.Value : myOrders.BillingCity)));
            parameters.Add(new SqlParameter("@BillingState", (string.IsNullOrEmpty(myOrders.BillingState) ? (object)DBNull.Value : myOrders.BillingState)));
            parameters.Add(new SqlParameter("@BillingCountry", (string.IsNullOrEmpty(myOrders.BillingCountry) ? (object)DBNull.Value : myOrders.BillingCountry)));
            parameters.Add(new SqlParameter("@BillingPostalCode", (string.IsNullOrEmpty(myOrders.BillingPostalCode) ? (object)DBNull.Value : myOrders.BillingPostalCode)));
            parameters.Add(new SqlParameter("@BillingMobile", (string.IsNullOrEmpty(myOrders.BillingMobile) ? (object)DBNull.Value : myOrders.BillingMobile)));
            parameters.Add(new SqlParameter("@BillingPhone", (string.IsNullOrEmpty(myOrders.BillingPhone) ? (object)DBNull.Value : myOrders.BillingPhone)));
            parameters.Add(new SqlParameter("@ShippingAddress1", (string.IsNullOrEmpty(myOrders.ShippingAddress1) ? (object)DBNull.Value : myOrders.ShippingAddress1)));
            parameters.Add(new SqlParameter("@ShippingAddress2", (string.IsNullOrEmpty(myOrders.ShippingAddress2) ? (object)DBNull.Value : myOrders.ShippingAddress2)));
            parameters.Add(new SqlParameter("@ShippingCity", (string.IsNullOrEmpty(myOrders.ShippingCity) ? (object)DBNull.Value : myOrders.ShippingCity)));
            parameters.Add(new SqlParameter("@ShippingState", (string.IsNullOrEmpty(myOrders.ShippingState) ? (object)DBNull.Value : myOrders.ShippingState)));
            parameters.Add(new SqlParameter("@ShippingCountry", (string.IsNullOrEmpty(myOrders.ShippingCountry) ? (object)DBNull.Value : myOrders.ShippingCountry)));
            parameters.Add(new SqlParameter("@ShippingPostalCode", (string.IsNullOrEmpty(myOrders.ShippingPostalCode) ? (object)DBNull.Value : myOrders.ShippingPostalCode)));
            parameters.Add(new SqlParameter("@ShippingMobile", (string.IsNullOrEmpty(myOrders.ShippingMobile) ? (object)DBNull.Value : myOrders.ShippingMobile)));
            parameters.Add(new SqlParameter("@ShippingPhone", (string.IsNullOrEmpty(myOrders.ShippingPhone) ? (object)DBNull.Value : myOrders.ShippingPhone)));
            parameters.Add(new SqlParameter("@IsShipToBillingAddress", myOrders.IsShipToBillingAddress));
            parameters.Add(new SqlParameter("@SubTotal", (myOrders.SubTotal == 0 ? (object)DBNull.Value : myOrders.SubTotal)));
            parameters.Add(new SqlParameter("@Discount", (myOrders.Discount == 0 ? (object)DBNull.Value : myOrders.Discount)));
            parameters.Add(new SqlParameter("@Shipping", (myOrders.Shipping == 0 ? (object)DBNull.Value : myOrders.Shipping)));
            parameters.Add(new SqlParameter("@TotalBeforeGST", (myOrders.TotalBeforeGST == 0 ? (object)DBNull.Value : myOrders.TotalBeforeGST)));
            parameters.Add(new SqlParameter("@GST", (myOrders.GST == 0 ? (object)DBNull.Value : myOrders.GST)));
            parameters.Add(new SqlParameter("@Total", (myOrders.Total == 0 ? (object)DBNull.Value : myOrders.Total)));
            parameters.Add(new SqlParameter("@PaidAmount", (myOrders.PaidAmount == 0 ? (object)DBNull.Value : myOrders.PaidAmount)));
            parameters.Add(new SqlParameter("@PromoCode", (string.IsNullOrEmpty(myOrders.PromoCode) ? (object)DBNull.Value : myOrders.PromoCode)));
            parameters.Add(new SqlParameter("@PromoDiscountAmount", (myOrders.PromoDiscountAmount == 0 ? (object)DBNull.Value : myOrders.PromoDiscountAmount)));
            parameters.Add(new SqlParameter("@PaymentMethod", (string.IsNullOrEmpty(myOrders.PaymentMethod) ? (object)DBNull.Value : myOrders.PaymentMethod)));
            parameters.Add(new SqlParameter("@PaymentType", (string.IsNullOrEmpty(myOrders.PaymentType) ? (object)DBNull.Value : myOrders.PaymentType)));
            parameters.Add(new SqlParameter("@PaymentStatus", (string.IsNullOrEmpty(myOrders.PaymentStatus) ? (object)DBNull.Value : myOrders.PaymentStatus)));
            parameters.Add(new SqlParameter("@TransactionReference", (string.IsNullOrEmpty(myOrders.TransactionReference) ? (object)DBNull.Value : myOrders.TransactionReference)));
            parameters.Add(new SqlParameter("@Comments", (string.IsNullOrEmpty(myOrders.Comments) ? (object)DBNull.Value : myOrders.Comments)));
            parameters.Add(new SqlParameter("@IsUrgentDelivery", myOrders.IsUrgentDelivery));
            parameters.Add(new SqlParameter("@OrderNumber", (string.IsNullOrEmpty(myOrders.OrderNumber) ? (object)DBNull.Value : myOrders.OrderNumber)));
            //parameters.Add(new SqlParameter("@OffLineNumber", (string.IsNullOrEmpty(myOrders.OffLineNumber) ? (object)DBNull.Value : myOrders.OffLineNumber)));
            //parameters.Add(new SqlParameter("@DONumber", (string.IsNullOrEmpty(myOrders.DONumber) ? (object)DBNull.Value : myOrders.DONumber)));
            parameters.Add(new SqlParameter("@InvoiceNo", (string.IsNullOrEmpty(myOrders.InvoiceNo) ? (object)DBNull.Value : myOrders.InvoiceNo)));
            parameters.Add(new SqlParameter("@QuotationReferenceID", ((myOrders.QuotationReferenceID != Guid.Empty && myOrders.QuotationReferenceID != null) ? myOrders.QuotationReferenceID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@OrderStatus", (string.IsNullOrEmpty(myOrders.OrderStatus) ? (object)DBNull.Value : myOrders.OrderStatus)));
            parameters.Add(new SqlParameter("@EarliestAvailableDate", (myOrders.EarliestAvailableDate == DateTime.MinValue) ? (object)DBNull.Value : myOrders.EarliestAvailableDate));
            parameters.Add(new SqlParameter("@DeliveryTime", (string.IsNullOrEmpty(myOrders.DeliveryTime) ? (object)DBNull.Value : myOrders.DeliveryTime)));
            parameters.Add(new SqlParameter("@ShippingOption", (string.IsNullOrEmpty(myOrders.ShippingOption) ? (object)DBNull.Value : myOrders.ShippingOption)));
            parameters.Add(new SqlParameter("@DesignerName", (string.IsNullOrEmpty(myOrders.DesignerName) ? (object)DBNull.Value : myOrders.DesignerName)));
            parameters.Add(new SqlParameter("@DesignerRemarks", (string.IsNullOrEmpty(myOrders.DesignerRemarks) ? (object)DBNull.Value : myOrders.DesignerRemarks)));
            //parameters.Add(new SqlParameter("@Remarks", (string.IsNullOrEmpty(myOrders.Remarks) ? (object)DBNull.Value : myOrders.Remarks)));
            parameters.Add(new SqlParameter("@CreatedBy", ((myOrders.AdminUserAccountID != Guid.Empty && myOrders.AdminUserAccountID != null) ? myOrders.AdminUserAccountID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@IsActive", myOrders.IsActive));
            //parameters.Add(new SqlParameter("@IsDeleted", myOrders.IsDeleted));
            parameters.Add(new SqlParameter("@Mode", myOrders.Mode));
            parameters.Add(new SqlParameter("@ServiceTax", myOrders.ServiceTax));
            parameters.Add(new SqlParameter("@TotalDiscount", myOrders.TotalDiscount));
            parameters.Add(new SqlParameter("@HappyHoursDiscount", myOrders.HappyHoursDiscount));
            parameters.Add(new SqlParameter("@TableNumber", (string.IsNullOrEmpty(myOrders.TableNumber)) ? (object)DBNull.Value : myOrders.TableNumber));

            parameters.Add(new SqlParameter("@DiscountType", (string.IsNullOrEmpty(myOrders.DiscountType)) ? (object)DBNull.Value : myOrders.DiscountType));
            parameters.Add(new SqlParameter("@DiscountValue", (myOrders.DiscountValue == 0 ? (object)DBNull.Value : myOrders.DiscountValue)));
            parameters.Add(new SqlParameter("@ServiceTaxType", (string.IsNullOrEmpty(myOrders.ServiceTaxType)) ? (object)DBNull.Value : myOrders.ServiceTaxType));
            parameters.Add(new SqlParameter("@ServiceTaxValue", (myOrders.ServiceTaxValue == 0 ? (object)DBNull.Value : myOrders.ServiceTaxValue)));
            parameters.Add(new SqlParameter("@RoundedAmount", (myOrders.RoundedAmount == 0 ? (object)DBNull.Value : myOrders.RoundedAmount)));

            SQLHelper.ExecuteQuery("spAddOrUpdateOrders", parameters);

        }

        public static void Delete()
        {
            //if (GlobalConfigurations.AppConfiguration.IsLocalDatabase)
            //{
            string SQL = string.Empty;
            SQL = @"DELETE FROM Orders";
            SQLHelper.ExecuteQueryStatement(SQL.ToString());
            //}
        }

        public static void GenerateInvoice(Guid ordersID)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@OrdersID", ordersID));

            SQLHelper.ExecuteQuery("spGenerateInvoiceForOrders", parameters);
        }

        //public static void GenerateDO(Guid ordersID)
        //{
        //List<SqlParameter> parameters = new List<SqlParameter>();
        //parameters.Add(new SqlParameter("@OrdersID", ordersID));

        //SQLHelper.ExecuteQuery("spGenerateDOForOrders", parameters);
        //}
    }
}
